/*
  ******************************************************************************
  * Copyright (c)  2008 - 2022, Shanghai AisinoChip Co.,Ltd .
  * @file    APP.c 
  * @version V1.0.0
  * @date    2022
  * @author  Aisinochip Firmware Team  
  * @brief   Standby Mode demo source code.
  ******************************************************************************        
*/
#include "APP.h"

GPIO_InitTypeDef GPIOA_Handle;


void GPIO_Turn()  /* תPA1ʱ */
{
    uint32_t i;
    GPIOA_Handle.Pin       = GPIO_PIN_1 ;
    GPIOA_Handle.Mode      = GPIO_MODE_OUTPUT_PP;
    GPIOA_Handle.Pull      = GPIO_PULLUP;
    GPIOA_Handle.Alternate = GPIO_FUNCTION_0;

    HAL_GPIO_Init(GPIOA, &GPIOA_Handle);

    for(i = 0; i < 100 * 5000; i++)
    {   HAL_GPIO_WritePin(GPIOA,GPIO_PIN_1 , GPIO_PIN_SET);

        HAL_GPIO_WritePin(GPIOA,GPIO_PIN_1 , GPIO_PIN_CLEAR);
    }
}

/*********************************************************************************
*  :  Enter_LowPower_Standby
*    :  Standby & ģģIP 
* ˵   :  
*    :  
*    :  
**********************************************************************************/
void Enter_LowPower_Standby(void)
{
    HAL_RTC_PCLK_ENABLE();
	/*----------------standyģʽǰ-------------*/
    /* IOλģ */
    SCU->PABADS= 0xFFFFFFFF;
    SCU->PCDADS  = 0xFFFFFFFF;

	/*ʱлRC*/
	SCU->CCR1 =SYS_CLK_SRC_RCH;
    /* رXTHXTLRC4M32K ʱ  */
    SCU->RCHCR&= ~(1 << 16);    // RC4M Disable
    SCU->XTHCR &= ~(1 <<  0);    // XTH  Disable

    SCU->STOPCFG   |=  (1 << 0);    // RTCдʹ
    PMU->ANACR &= ~(1 << 0);    // XTL   Disable
    PMU->ANACR &= ~(1 << 8);    // RC32K Disable

    /* RTCCLK Disable */
    PMU->CR1 &= ~(1 << 5);

    /* Standbyģʽ */
    SCU->STOPCFG |= (1 << 11);//PDDS  DeepSleep ½ STANDBY ģʽϵ
    /* ־Standby */
    PMU->CR1  |= (6 << 9) | (1 << 8) | (1 << 0);
	
    /* PC13 */
    PMU->CR1 |= 1 << 17;//WKUP6~2 ܽŻѹʹ 
    PMU->CR1 |= 1 <<  1;//1ѱ־

    /* Ĭػ */ 
	PMU->IOCR  &= ~(1 << 6);   //Ϊֽӿ
    PMU->IOCR  &= ~(1 << 0);
    PMU->IOCR  |= 1 << 1;
 
    /* LVD Disable */
    SCU->LVDCFG &= ~(1 << 0);

    /* All Clock Disable */
    SCU->CLKOCR &= ~(1ul << 31);    // Buzzer2 Disable
    SCU->CLKOCR &= ~(1ul << 23);    // Buzzer1 Disable
	
	/*-----------standyģʽ,ȴ--------*/
	System_Enter_Standby_Mode();

}
/*********************************************************************************
* Function    : APP_Power_Standby_Test
* Description : 
* Input       : None
* Output      : None
**********************************************************************************/
void APP_Power_Standby_Test(void)
{
    GPIO_Turn();   //IOת൱ʱ(Ѻ)
    
    printfS("MCU enter standby mode, MCU will wakeup by PC13 rising edge!\n");
    
    Enter_LowPower_Standby();
      
}
