 /***********************************************************************
 * Filename    : app.c
 * Description : app source file
 * Author(s)   : Xiao han
 * version     : V1.0
 * Modify date : 2020-03-19
 ***********************************************************************/
 
#include "APP.h"

OPA_HandleTypeDef OPA1_Handle;
OPA_HandleTypeDef OPA2_Handle;
OPA_HandleTypeDef OPA3_Handle;
/************************************************************************
 * function   : OPA_Init
 * Description: OPA Initiation. 
 ************************************************************************/ 
void OPA_Init(void)
{
    OPA1_Handle.Instance = OPA;
    OPA1_Handle.Init.OpaX = OPA1;
    OPA1_Handle.Init.VinPSel = OPA_CSR1_VINPSEL_PB6;
    OPA1_Handle.Init.VinMSel = OPA_CSR1_VINMSEL_PB5;
    OPA1_Handle.Init.TrimEn = OPA_CSR_TRIM_ENABLE;

    HAL_OPA_Init(&OPA1_Handle);

    OPA2_Handle.Instance = OPA;
    OPA2_Handle.Init.OpaX = OPA2;
    OPA2_Handle.Init.VinPSel = OPA_CSR2_VINPSEL_PB3;
    OPA2_Handle.Init.VinMSel = OPA_CSR2_VINMSEL_PB1;
    OPA2_Handle.Init.TrimEn = OPA_CSR_TRIM_ENABLE;

    HAL_OPA_Init(&OPA2_Handle);

    OPA3_Handle.Instance = OPA;
    OPA3_Handle.Init.OpaX = OPA3;
    OPA3_Handle.Init.VinPSel = OPA_CSR3_VINPSEL_PA7;
    OPA3_Handle.Init.VinMSel = OPA_CSR3_VINMSEL_PA5;
    OPA3_Handle.Init.TrimEn = OPA_CSR_TRIM_ENABLE;

    HAL_OPA_Init(&OPA3_Handle);
}

/************************************************************************
 * function   : OPA_Test
 * Description: OPA 1,2,3 enable. 
 *              OPA trim enable. 
 ************************************************************************/ 
void OPA_Test(void)
{
    printfS("OPA Test is Ready!!! \r\n");

    OPA_Init();
    
    printfS("OPA Inition OK!\r\n");
}
