/***********************************************************************
 * All rights reserved.
 * Filename    : lcd_H50261ARP.h
 * Description : lcd_H50261ARP driver header file
 * Author(s)   : ZK      
 * version     : V1.0
 * Modify date : 2022-06-23
 ***********************************************************************/
#ifndef __LCD_H50261ARP_H__

#define __LCD_H50261ARP_H__

#include "ACM32Fxx_HAL.h"

/**
  @verbatim
================================================================================
                              H50261ARP LCD ֵ
================================================================================
                                   A
                               ----------
                              |         |
                             F|         |B
                              |         |
                              ---- G-----          4
                              |         |
                             E|         |C
                              |         |   _ 
                              -----------  |_|P  
                                   D

 A LCD character coding is based on the following matrix:
PIN     5	6	7	8	9	10	11	12	13	14	NC	NC	NC	20	16	15	NC	NC	NC	19	NC	NC	17	18	23	21	22	24	NC	NC	NC	NC
YR	    S0	S1	S2	S3	S4	S5	S6	S7	S8	S9	NC	NC	NC	S15	S11	S10	NC	NC	NC	S14	NC	NC	S12	S13	S18	S16	S17	S19	NC	NC	NC	NC
MCU	    S0	S1	S2	S3	S4	S5	S6	S7	S8	S9	S10	S11	S12	S13	S14	S15	S16	S17	S18	S19	S20	S21	S22	S23	S24	S25	S26	S27	S28	S29	S30	S31
COM0	1A	1B	2A	2B	3A	3B	4A	4B	S9	S10	NC	NC	NC	7B	5B	5A	NC	NC	NC	7A	NC	NC	6A	6B	S1	8A	8B	S14	NC	NC	NC	NC
COM1	1F	1G	2F	2G	3F	3G	4F	4G	S8	S11	NC	NC	NC	7G	5G	5F	NC	NC	NC	7F	NC	NC	6F	6G	S2	8F	8G	S16	NC	NC	NC	NC
COM2	1E	1C	2E	2C	3E	3C	4E	4C	S7	S12	NC	NC	NC	7C	5C	5E	NC	NC	NC	7E	NC	NC	6E	6C	S3	8E	8C	S15	NC	NC	NC	NC
COM3	1D	1P	2D	2P	3P	3P	4D	L1	S6	S5	NC	NC	NC	7P	5P	5D	NC	NC	NC	7D	NC	NC	6D	6P	S4	8D	L2	S13	NC	NC	NC	NC
        1    2   1   2   1   2   1   2   1   2   1   2   1   1   1   2   1   2   1  40   1   2   1   2   1   2   1    2  1   2   1   2
  
  һλҪʾ0λ
          SEG0    SEG1    SEG2    SEG3   SEG4   SEG5   SEG6    SEG7  
  COM0  { 1 ,     1 ,      0 ,    0 ,     0 ,    0 ,    0 ,     0 ,}
  COM1  { 0 ,     1 ,      0 ,    0 ,     0 ,    0 ,    0 ,     0 ,}
  COM2  { 1 ,     1 ,      0 ,    0 ,     0 ,    0 ,    0 ,     0 ,}
  COM3  { 0 ,     1 ,      0 ,    0 ,     0 ,    0 ,    0 ,     0 ,}


===>ʾģʽ14COMҪ4LCDRAM
ʣLCDʾģʽ1
//mode0ʽ;         RAM0:   xxxxxSEG3xxxxxxxxxxSEG2xxxxxxxxxxSEG1xxxxxxxxxxSEG0xxxxx  
//                   RAM1:   xxxxxSEG7xxxxxxxxxxSEG6xxxxxxxxxxSEG5xxxxxxxxxxSEG4xxxxx

//mode1ʽ;         RAM0:   SEG31xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxSEG0  
//                   RAM1:   SEG31xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxSEG0
//                   RAM2:   SEG31xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxSEG0  
//                   RAM3:   SEG31xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxSEG0
================================================================================
  @endverbatim
  */


extern uint16_t H50261ARP_S_DATA[16];


//1,2,3,4,5
#define H50261ARP_NUM12345_SEG_A    0x00000002
#define H50261ARP_NUM12345_SEG_B    0x00000002
#define H50261ARP_NUM12345_SEG_C    0x00000002
#define H50261ARP_NUM12345_SEG_D    0x00000001
#define H50261ARP_NUM12345_SEG_E    0x00000001
#define H50261ARP_NUM12345_SEG_F    0x00000001
#define H50261ARP_NUM12345_SEG_G    0x00000001



//num & xP

#define H50261ARP_NUM_1_OFFSET    4
#define H50261ARP_NUM_2_OFFSET    6
#define H50261ARP_NUM_3_OFFSET    8
#define H50261ARP_NUM_4_OFFSET    0
#define H50261ARP_NUM_5_OFFSET    2

#define H50261ARP_RAM0_SEG_2P         0x00000002

//S
#define H50261ARP_RAM0_OFFSET_T1              3
#define H50261ARP_RAM0_OFFSET_T2              5
#define H50261ARP_RAM0_OFFSET_T3              15
#define H50261ARP_RAM1_OFFSET_T4              15
#define H50261ARP_RAM2_OFFSET_T5              15
#define H50261ARP_RAM3_OFFSET_T6              15
#define H50261ARP_RAM0_OFFSET_T7              9              


//SET S
#define H50261ARP_T1              0x0001
#define H50261ARP_T2              0x0002
#define H50261ARP_T3              0x0004
#define H50261ARP_T4              0x0008
#define H50261ARP_T5              0x0010
#define H50261ARP_T6              0x0020
#define H50261ARP_T7              0x0040





#define H50261ARP_RAM0   0
#define H50261ARP_RAM1   1
#define H50261ARP_RAM2   2
#define H50261ARP_RAM3   3
//1,2,3,4,6,8

#define H50261ARP_NUM12345_0_RAM0   (H50261ARP_NUM12345_SEG_D)
#define H50261ARP_NUM12345_0_RAM1   (H50261ARP_NUM12345_SEG_C+H50261ARP_NUM12345_SEG_E)
#define H50261ARP_NUM12345_0_RAM2   (H50261ARP_NUM12345_SEG_B)
#define H50261ARP_NUM12345_0_RAM3   (H50261ARP_NUM12345_SEG_A+H50261ARP_NUM12345_SEG_F)

#define H50261ARP_NUM12345_1_RAM0   (0)
#define H50261ARP_NUM12345_1_RAM1   (H50261ARP_NUM12345_SEG_C)
#define H50261ARP_NUM12345_1_RAM2   (H50261ARP_NUM12345_SEG_B)
#define H50261ARP_NUM12345_1_RAM3   (0)

#define H50261ARP_NUM12345_2_RAM0   (H50261ARP_NUM12345_SEG_D)
#define H50261ARP_NUM12345_2_RAM1   (H50261ARP_NUM12345_SEG_E)
#define H50261ARP_NUM12345_2_RAM2   (H50261ARP_NUM12345_SEG_B+H50261ARP_NUM12345_SEG_G)
#define H50261ARP_NUM12345_2_RAM3   (H50261ARP_NUM12345_SEG_A)

#define H50261ARP_NUM12345_3_RAM0   (H50261ARP_NUM12345_SEG_D)
#define H50261ARP_NUM12345_3_RAM1   (H50261ARP_NUM12345_SEG_C)
#define H50261ARP_NUM12345_3_RAM2   (H50261ARP_NUM12345_SEG_B+H50261ARP_NUM12345_SEG_G)
#define H50261ARP_NUM12345_3_RAM3   (H50261ARP_NUM12345_SEG_A)


#define H50261ARP_NUM12345_4_RAM0    (0)
#define H50261ARP_NUM12345_4_RAM1   (H50261ARP_NUM12345_SEG_C)
#define H50261ARP_NUM12345_4_RAM2   (H50261ARP_NUM12345_SEG_B+H50261ARP_NUM12345_SEG_G)
#define H50261ARP_NUM12345_4_RAM3   (H50261ARP_NUM12345_SEG_F)

#define H50261ARP_NUM12345_5_RAM0   (H50261ARP_NUM12345_SEG_D)
#define H50261ARP_NUM12345_5_RAM1   (H50261ARP_NUM12345_SEG_C)
#define H50261ARP_NUM12345_5_RAM2   (H50261ARP_NUM12345_SEG_G)
#define H50261ARP_NUM12345_5_RAM3   (H50261ARP_NUM12345_SEG_A+H50261ARP_NUM12345_SEG_F)

#define H50261ARP_NUM12345_6_RAM0   (H50261ARP_NUM12345_SEG_D)
#define H50261ARP_NUM12345_6_RAM1   (H50261ARP_NUM12345_SEG_C+H50261ARP_NUM12345_SEG_E)
#define H50261ARP_NUM12345_6_RAM2   (H50261ARP_NUM12345_SEG_G)
#define H50261ARP_NUM12345_6_RAM3   (H50261ARP_NUM12345_SEG_A+H50261ARP_NUM12345_SEG_F)

#define H50261ARP_NUM12345_7_RAM0   (0)
#define H50261ARP_NUM12345_7_RAM1   (H50261ARP_NUM12345_SEG_C)
#define H50261ARP_NUM12345_7_RAM2   (H50261ARP_NUM12345_SEG_B)
#define H50261ARP_NUM12345_7_RAM3   (H50261ARP_NUM12345_SEG_A)

#define H50261ARP_NUM12345_8_RAM0   (H50261ARP_NUM12345_SEG_D)
#define H50261ARP_NUM12345_8_RAM1   (H50261ARP_NUM12345_SEG_C+H50261ARP_NUM12345_SEG_E)
#define H50261ARP_NUM12345_8_RAM2   (H50261ARP_NUM12345_SEG_B+H50261ARP_NUM12345_SEG_G)
#define H50261ARP_NUM12345_8_RAM3   (H50261ARP_NUM12345_SEG_A+H50261ARP_NUM12345_SEG_F)

#define H50261ARP_NUM12345_9_RAM0   (H50261ARP_NUM12345_SEG_D)
#define H50261ARP_NUM12345_9_RAM1   (H50261ARP_NUM12345_SEG_C)
#define H50261ARP_NUM12345_9_RAM2   (H50261ARP_NUM12345_SEG_B+H50261ARP_NUM12345_SEG_G)
#define H50261ARP_NUM12345_9_RAM3   (H50261ARP_NUM12345_SEG_A+H50261ARP_NUM12345_SEG_F)




#define LCD_H50261ARP_BACK_LED_ON HAL_GPIO_WritePin(GPIOA,GPIO_PIN_5,GPIO_PIN_SET);
#define LCD_H50261ARP_BACK_LED_OFF HAL_GPIO_WritePin(GPIOA,GPIO_PIN_5,GPIO_PIN_CLEAR);

#define GetLCDBackKey() HAL_GPIO_ReadPin(GPIOC,GPIO_PIN_15)
#define LCD_BACK_LED_EN GPIO_PIN_CLEAR

void LCD_H50261ARP_BACK_LED(void);

void LCD_DisplayNum_H50261ARP(uint32_t Numup);
void LCD_Init_H50261ARP(void);

void LCD_H50261ARP_Get_RAM_NUM_DATA(uint32_t *ram_updata,uint16_t num_up,uint16_t num_down);
uint32_t Get_RAM_xP_DATA(uint8_t ram_num,uint16_t num_xp);
void LCD_DisplayNum_H50261ARP_INIT(void);
void LCD_H50261ARP_VIEW(uint32_t *Displayup,uint32_t *Displaydown,uint32_t *num_p,uint32_t *num_col,uint32_t num_s);
void LCD_H50261ARP_THDisplay(float *getTempHum);
void LCD_H50261ARP_SelfDisplay(void);
#endif
