
#include "buzzer.h"
#include "app.h"



#if defined LCD_YR1618A
    #define BUZZER_GPIO_PORT        GPIOD
    #define BUZZER_GPIO_PIN         GPIO_PIN_1
#elif defined LCD_H50261ARP
    #define BUZZER_GPIO_PORT        GPIOB
    #define BUZZER_GPIO_PIN         GPIO_PIN_10
#endif


/*****************************************************************
@ԭ	void BUZZER_Init(void)
@	ʼ
@		 
@	
******************************************************************/
void BUZZER_Init(void)
{
    GPIO_InitTypeDef GPIOx_Handle;    
    GPIOx_Handle.Pin       = BUZZER_GPIO_PIN;
    GPIOx_Handle.Mode      = GPIO_MODE_OUTPUT_PP;
    GPIOx_Handle.Pull      = GPIO_NOPULL;
    GPIOx_Handle.Alternate = GPIO_FUNCTION_0;
    HAL_GPIO_Init(BUZZER_GPIO_PORT, &GPIOx_Handle);  
    HAL_GPIO_WritePin(BUZZER_GPIO_PORT, BUZZER_GPIO_PIN, GPIO_PIN_CLEAR);
}

/*****************************************************************
@	(ʽ)
@	ms - ʱ	 
@	
******************************************************************/
void Beep_On(int ms)
{  
    HAL_GPIO_WritePin(BUZZER_GPIO_PORT, BUZZER_GPIO_PIN, GPIO_PIN_SET);
    System_Delay_MS(ms);
    HAL_GPIO_WritePin(BUZZER_GPIO_PORT, BUZZER_GPIO_PIN, GPIO_PIN_CLEAR);
  
           
}





