
#ifndef __TKEY_H__
#define __TKEY_H__

#include "ACM32Fxx_HAL.h"

//#define TKEY_WAVEFORM_OUTPUT              //TKEYεACTouchKeyTool.exeԹ

#define TKEY_FIFO_ENABLE   //ֵװfifoʹ

//#define MULTI_KEY_SHIELD_OUTPUT_MAX   //ͨΣͬһͬʱֻ仯һ
#define MULTI_KEY_SHIELD_OUT_NONE     //ͨΣͬһͬʱ

#define NO_KEY_DOWN             0xFF
#define OTHER_KEY_DOWN          0x55
#define KEY_DOWN                0x00
 
/****************  TKEYʱɨ  *****************/
//#define TKEY_TIM_SCAN_ENABLE    //ʱɨTKEYʹ
#ifdef  TKEY_TIM_SCAN_ENABLE
    #define TKEY_SCAN_TIMX                      TIM17 
    #define TKEY_SCAN_TIMX_IRQn                 TIM17_IRQn 
    #define TKEY_SCAN_TIMX_IRQHandler           TIM17_IRQHandler  
    #define TKEY_SCAN_TIMX_IRQn_PRIORITY        1      //жȼ
    #define TKEY_SCAN_TIM_PERIOD                5      //TKEYɨ趨ʱ(ms)
#endif
/*******************************************************/


#define TKEY_QUICK_QUICK_CALIBRATE_TIMES    3    //У׼

/******************************************************************************
*  ɨȴʱ:ֵԽ,ӦٶȱΪTKEY_SCAN_WAIT_MAX_TIMES; ֵСᵼ»ȡRawDataֵ
*******************************************************************************/
#define TKEY_SCAN_WAIT_TIMES              5 
#define TKEY_SCAN_WAIT_MAX_TIMES          100  
/******************************************************************************
*  ɨȴʱԼϵ:ֵԽ,ԼԽС,ԼٶԽ,У׼ʱ;
*  ֵԽС,ԼֵԽ,ԼٶԽ죬У׼ʱС;
*******************************************************************************/
#define TKEY_SCAN_WAIT_TIMES_RATIO        10  //20% 

/******************************************************************************
*  RawData²Χϵ:ֵԽ,ΧԽС,BsaeLineֵԽӽRawData,У׼Խ׼ȷ;
*  ֵᵼ»ȡBsaeLineֵ,У׼СֵΪTKEY_RAWDATA_RANGE_MIN_RATIO
*  Χ[-RawData/TKEY_DELTA_DIVISOR, +RawData/TKEY_DELTA_DIVISOR] 
*******************************************************************************/
#define TKEY_RAWDATA_RANGE_RATIO          100
#define TKEY_RAWDATA_RANGE_MIN_RATIO      50  
/******************************************************************************
*  RawData²ΧϵԼϵ:ֵԽ,ԼԽС,ԼٶԽ,У׼ʱ;
*  ֵԽС,ԼֵԽ,ԼٶԽ죬У׼ʱС;
*******************************************************************************/
#define TKEY_RAWDATA_RANGE_DEC_RATIO      15  //10% 


/******************************************************************************
*  TKey 16ͨʹܺ궨
*  Ҫʹ·ʹܸͨ;δʹõİͨҪʹ,ȻУ׼ʧ
*******************************************************************************/
//#define TKEY_CHANNEL_0_ENABLE        //--ӦоƬܽTVCX0, λTK_0               
//#define TKEY_CHANNEL_1_ENABLE           //--ӦоƬܽTVCX1, λTK_1	               
//#define TKEY_CHANNEL_2_ENABLE           //--ӦоƬܽTVCX2, λTK_2                
//#define TKEY_CHANNEL_3_ENABLE        //--ӦоƬܽTVCX3, λTK_3                  
//#define TKEY_CHANNEL_4_ENABLE           //--ӦоƬܽTVCX4, λTK_4                
//#define TKEY_CHANNEL_5_ENABLE           //--ӦоƬܽTVCX5, λTK_5              
//#define TKEY_CHANNEL_6_ENABLE        //--ӦоƬܽTVCX6, λTK_6                 
#define TKEY_CHANNEL_7_ENABLE        //--ӦоƬܽTVCX7, λTK_7                 
#define TKEY_CHANNEL_8_ENABLE           //--ӦоƬܽTVCX8, λTK_8               
#define TKEY_CHANNEL_9_ENABLE           //--ӦоƬܽTVCX9, λTK_9               
#define TKEY_CHANNEL_10_ENABLE          //--ӦоƬܽTVCX10, λTK_10              
#define TKEY_CHANNEL_11_ENABLE          //--ӦоƬܽTVCX11, λTK_11
//#define TKEY_CHANNEL_12_ENABLE          //--ӦоƬܽTVCX12, λTK_12               
//#define TKEY_CHANNEL_13_ENABLE          //--ӦоƬܽTVCX13, λTK_13              
//#define TKEY_CHANNEL_14_ENABLE          //--ӦоƬܽTVCX14, λTK_14               
#define TKEY_CHANNEL_15_ENABLE          //--ӦоƬܽTVCX15, λTK_15            


/******************************************************************************
*  TKey 16ͨģʽ
*  ֵԽС,Խ;ֵԽ,Խ.δʹܵİͨΪ4095.
*******************************************************************************/
#define TKEY_0_SENSITIVITY            4095    //--ӦоƬܽTVCX0, λTK_0
#define TKEY_1_SENSITIVITY            4095	  //--ӦоƬܽTVCX1, λTK_1		
#define TKEY_2_SENSITIVITY            4095      //--ӦоƬܽTVCX2, λTK_2 
#define TKEY_3_SENSITIVITY            4095    //--ӦоƬܽTVCX3, λTK_3 
#define TKEY_4_SENSITIVITY            4095      //--ӦоƬܽTVCX4, λTK_4  
#define TKEY_5_SENSITIVITY            4095      //--ӦоƬܽTVCX5, λTK_5
#define TKEY_6_SENSITIVITY            4095    //--ӦоƬܽTVCX6, λTK_6 
#define TKEY_7_SENSITIVITY            60    //--ӦоƬܽTVCX7, λTK_7
#define TKEY_8_SENSITIVITY            60      //--ӦоƬܽTVCX8, λTK_8 
#define TKEY_9_SENSITIVITY            60      //--ӦоƬܽTVCX9, λTK_9
#define TKEY_10_SENSITIVITY           60      //--ӦоƬܽTVCX10, λTK_10 
#define TKEY_11_SENSITIVITY           60      //--ӦоƬܽTVCX11, λTK_11
#define TKEY_12_SENSITIVITY           4095      //--ӦоƬܽTVCX12, λTK_12
#define TKEY_13_SENSITIVITY           4095      //--ӦоƬܽTVCX13, λTK_13
#define TKEY_14_SENSITIVITY           4095      //--ӦоƬܽTVCX14, λTK_14
#define TKEY_15_SENSITIVITY           60      //--ӦоƬܽTVCX15, λTK_15 

/******************************************************************************
*  TKey 16ͨ˯ģʽ
*  ֵԽС,Խ;ֵԽ,Խ.δʹܵİͨΪ4095.
*******************************************************************************/
#define TKEY_0_SLEEP_SENSITIVITY           (TKEY_0_SENSITIVITY)    //--ӦоƬܽTVCX0, λTK_0
#define TKEY_1_SLEEP_SENSITIVITY           (TKEY_1_SENSITIVITY)       //--ӦоƬܽTVCX1, λTK_1
#define TKEY_2_SLEEP_SENSITIVITY           (TKEY_2_SENSITIVITY)       //--ӦоƬܽTVCX2, λTK_2 
#define TKEY_3_SLEEP_SENSITIVITY           (TKEY_3_SENSITIVITY)     //--ӦоƬܽTVCX3, λTK_3  
#define TKEY_4_SLEEP_SENSITIVITY           (TKEY_4_SENSITIVITY)       //--ӦоƬܽTVCX4, λTK_4 
#define TKEY_5_SLEEP_SENSITIVITY           (TKEY_5_SENSITIVITY)       //--ӦоƬܽTVCX5, λTK_5  
#define TKEY_6_SLEEP_SENSITIVITY           (TKEY_6_SENSITIVITY)     //--ӦоƬܽTVCX6, λTK_6  
#define TKEY_7_SLEEP_SENSITIVITY           (TKEY_7_SENSITIVITY)     //--ӦоƬܽTVCX7, λTK_7  
#define TKEY_8_SLEEP_SENSITIVITY           (TKEY_8_SENSITIVITY)       //--ӦоƬܽTVCX8, λTK_8  
#define TKEY_9_SLEEP_SENSITIVITY           (TKEY_9_SENSITIVITY)      //--ӦоƬܽTVCX9, λTK_9  
#define TKEY_10_SLEEP_SENSITIVITY          (TKEY_10_SENSITIVITY)       //--ӦоƬܽTVCX10, λTK_10 
#define TKEY_11_SLEEP_SENSITIVITY          (TKEY_11_SENSITIVITY)       //--ӦоƬܽTVCX11, λTK_11  
#define TKEY_12_SLEEP_SENSITIVITY          (TKEY_12_SENSITIVITY)       //--ӦоƬܽTVCX12, λTK_12  
#define TKEY_13_SLEEP_SENSITIVITY          (TKEY_13_SENSITIVITY)       //--ӦоƬܽTVCX13, λTK_13  
#define TKEY_14_SLEEP_SENSITIVITY          (TKEY_14_SENSITIVITY)       //--ӦоƬܽTVCX14, λTK_14  
#define TKEY_15_SLEEP_SENSITIVITY          (TKEY_15_SENSITIVITY)       //--ӦоƬܽTVCX15, λTK_15 


typedef enum{
#ifdef  TKEY_CHANNEL_0_ENABLE 
  TK_0,   //0
#endif
#ifdef  TKEY_CHANNEL_1_ENABLE   
  TK_1,   //1
#endif
#ifdef  TKEY_CHANNEL_2_ENABLE 
  TK_2,   //2
#endif
#ifdef  TKEY_CHANNEL_3_ENABLE   
  TK_3,   //3
#endif
#ifdef  TKEY_CHANNEL_4_ENABLE   
  TK_4,   //4
#endif
#ifdef  TKEY_CHANNEL_5_ENABLE   
  TK_5,   //5
#endif
#ifdef  TKEY_CHANNEL_6_ENABLE   
  TK_6,   //6
#endif
#ifdef  TKEY_CHANNEL_7_ENABLE   
  TK_7,   //7
#endif
#ifdef  TKEY_CHANNEL_8_ENABLE   
  TK_8,   //8
#endif
#ifdef  TKEY_CHANNEL_9_ENABLE   
  TK_9,   //9
#endif
#ifdef  TKEY_CHANNEL_10_ENABLE   
  TK_10,  //10
#endif  
#ifdef  TKEY_CHANNEL_11_ENABLE   
  TK_11,  //11
#endif
#ifdef  TKEY_CHANNEL_12_ENABLE  
  TK_12,  //12
#endif
#ifdef  TKEY_CHANNEL_13_ENABLE   
  TK_13,  //13
#endif
#ifdef  TKEY_CHANNEL_14_ENABLE   
  TK_14,  //14
#endif
#ifdef  TKEY_CHANNEL_15_ENABLE   
  TK_15,   //15
#endif  
  TOTAL_CHANNELS
}TK_Index_enum_T;

void TKEY_Calibrate_ParaInit(void);

void TKEY_Timer_ScanInit(void);

void TKEY_Scan_FIFO_Clear(void);

void TKEY_Timer_Scan_Start(void);

void TKEY_Timer_Scan_Stop(void);

void TKEY_Init(void);

void TKEY_Suspend(void);

void TKEY_Resume(void);

void TKEY_Wakeup(void);

uint8_t TKEY_Quick_Calibrate(void);

void TKEY_Waveform_Output_Process(void);

void TKEY_Calibrate_Process(void);

void TKEY_RTC_Calibrate_Process(void);

void TouchKey_suspend(void);

void TouchKey_resume(void);

uint8_t TouchKey_Init(void);

uint8_t TouchKey_TimerSacn_GetKeyVal(void);

void Bubble_Sort(uint16_t *arr, uint16_t n);

uint16_t Calculate_Sample_Average(uint16_t *arr, uint16_t n);

uint16_t Calculate_Sample_differ(uint16_t *arr, uint16_t n, uint16_t average);

uint16_t TouchKey_GetPressRelaeseFlag(void);

void TouchKey_ClearPressRelaeseFlag(void);

uint16_t TouchKey_GetLongPressFlag(void);

void TouchKey_Switch_Clock_RC4M(void);

void TouchKey_Switch_Clock_PCLK(void);

void TKEY_Press_Relaese_Process(void);

#endif
