/*
******************************************************************************
* @file    APP.c
* @author  CWT
* @version V1.0.0
* @date    2020
* @brief   LCD demo source code.
******************************************************************************
*/
#include "APP.h" 
#include "SHT30.h" 
#ifdef LCD_GDC04212
#include "lcd_GDC04212.h"
#endif
#ifdef LCD_GDC03828
#include "lcd_GDC03828.h"
#endif
#ifdef LCD_YR1618A
#include "lcd_YR1618A.h"
#endif
#ifdef LCD_H50261ARP
#include "lcd_H50261ARP.h"
#endif
#include "buzzer.h"
#include "TKEY.h"

LCD_HandleTypeDef         *lcdhandle;  //LCD Handleָ

I2C_HandleTypeDef I2C_Handle;   //I2C Handleָ

#define BUFFER_LENGTH    (256)
uint8_t gu8_TxBuffer[BUFFER_LENGTH];
uint8_t gu8_RxBuffer[BUFFER_LENGTH];

uint8_t gu8_time_count_free = 0;//0-free,1-0.5s,2-1s,
uint32_t gu32_time_1s_cont = 0;

extern volatile uint32_t gu32_SystemCount;


void(*LCD_DisplayNum)(uint32_t);//LCDʾָ

void(*LCD_Init)(void);//LCDʼָ

extern void (*SysTick_Handler_Callback)(void);

extern LCD_HandleTypeDef         lcdhandle_GDC04212;
extern LCD_HandleTypeDef         lcdhandle_GDC03828;
extern LCD_HandleTypeDef         lcdhandle_YR1618A;
extern LCD_HandleTypeDef         lcdhandle_H50261ARP;

TIM_HandleTypeDef TIM6_Handler;  

DMA_HandleTypeDef  DMA_CH1_Handle; 

DMA_LLI_InitTypeDef DMA_CH1_Handle_link1;
DMA_LLI_InitTypeDef DMA_CH1_Handle_link2;
DMA_LLI_InitTypeDef DMA_CH1_Handle_link3;
DMA_LLI_InitTypeDef DMA_CH1_Handle_link4;
DMA_LLI_InitTypeDef DMA_CH1_Handle_link5;
DMA_LLI_InitTypeDef DMA_CH1_Handle_link6;
DMA_LLI_InitTypeDef DMA_CH1_Handle_link7;
DMA_LLI_InitTypeDef DMA_CH1_Handle_link8;
DMA_LLI_InitTypeDef DMA_CH1_Handle_link9;


#if defined LCD_GDC04212 //ӦGDC042129֡ݣֱʾΪ1111-"9999"
uint32_t wdata1[16]={0x06000600,0x06000600,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata2[16]={0x0B060B06,0x0B060B06,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata3[16]={0xF020F02,0xF020F02,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata4[16]={0x06030603,0x06030603,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata5[16]={0xD030D03,0xD030D03,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata6[16]={0x0D070D07,0x0D070D07,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata7[16]={0x07000700,0x07000700,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata8[16]={0x0F070F07,0x0F070F07,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata9[16]={0xF030F03,0xF030F03,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
#elif defined LCD_GDC03828 //ӦGDC038289֡ݣֱʾΪ1111-"9999"
uint32_t wdata1[16]={0x06000600,0x06000600,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata2[16]={0x0B060B06,0x0B060B06,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata3[16]={0xF020F02,0xF020F02,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata4[16]={0x06030603,0x06030603,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata5[16]={0xD030D03,0xD030D03,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata6[16]={0x0D070D07,0x0D070D07,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata7[16]={0x07000700,0x07000700,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata8[16]={0x0F070F07,0x0F070F07,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata9[16]={0xF030F03,0xF030F03,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
#elif defined LCD_YR1618A //ӦYR1618A9֡ݣֱʾΪ1111-"9999"
uint32_t wdata1[16]={0x06C8E0FF,0x02488055,0x06C8E0FF,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata2[16]={0x048060AA,0x00000000,0x048060AA,0x00000000,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata3[16]={0x06C8E0FF,0x048060AA,0x02488055,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata4[16]={0x06C8E0FF,0x048060AA,0x048060AA,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata5[16]={0x048060AA,0x06C8E0FF,0x048060AA,0x00000000,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata6[16]={0x02488055,0x06C8E0FF,0x048060AA,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata7[16]={0x02488055,0x06C8E0FF,0x06C8E0FF,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata8[16]={0x06C8E0FF,0x00000000,0x048060AA,0x00000000,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata9[16]={0x06C8E0FF,0x06C8E0FF,0x06C8E0FF,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
#elif defined LCD_H50261ARP //ӦH50261ARP9֡ݣֱʾΪ1111-"9999"
uint32_t wdata1[16]={0x06C8E0FF,0x02488055,0x06C8E0FF,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata2[16]={0x048060AA,0x00000000,0x048060AA,0x00000000,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata3[16]={0x06C8E0FF,0x048060AA,0x02488055,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata4[16]={0x06C8E0FF,0x048060AA,0x048060AA,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata5[16]={0x048060AA,0x06C8E0FF,0x048060AA,0x00000000,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata6[16]={0x02488055,0x06C8E0FF,0x048060AA,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata7[16]={0x02488055,0x06C8E0FF,0x06C8E0FF,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata8[16]={0x06C8E0FF,0x00000000,0x048060AA,0x00000000,0,0,0,0,0,0,0,0,0,0,0,0};
uint32_t wdata9[16]={0x06C8E0FF,0x06C8E0FF,0x06C8E0FF,0x02488055,0,0,0,0,0,0,0,0,0,0,0,0};
#endif

EXTI_HandleTypeDef EXTI_Line13_Handle;

GPIO_InitTypeDef GPIO_PC13_Handle;
/*********************************************************************************
* Function    : LCD_IRQHandler
* Description : LCD Interrupt handler
* Input       : 
* Outpu       : 
* Author      : CWT                         Data : 2021
**********************************************************************************/
void LCD_IRQHandler(void) 
{
    HAL_LCD_IRQHandler(lcdhandle);
  
}
/*********************************************************************************
* Function    : DMA_IRQHandler
* Description : DMA Interrupt handler
* Input       : 
* Outpu       : 
* Author      : CWT                         Data : 2021
**********************************************************************************/
void DMA_IRQHandler(void)
{
    HAL_DMA_IRQHandler(&DMA_CH1_Handle);
}
/************************************************************************
 * function   : HAL_I2C_MspInit
 * Description: 
 * input      : hi2c : pointer to a I2C_HandleTypeDef structure that contains
 *                     the configuration information for I2C module
 ************************************************************************/
void HAL_I2C_MspInit(I2C_HandleTypeDef *hi2c)
{
    /* 
      NOTE : This function should be modified by the user.
    */
    
    /* For Example */
    GPIO_InitTypeDef GPIO_Handle; 
    
    /* I2C1 */

    /* I2C2 */
    if (hi2c->Instance == I2C2) 
    {
        System_Module_Enable(EN_I2C2);  
        System_Module_Enable(EN_GPIOCD);   

        /* I2C2 SDA  PortD Pin7 */
        /* I2C2 SCL  PortD Pin6 */
        GPIO_Handle.Pin            = GPIO_PIN_6 | GPIO_PIN_7;
        GPIO_Handle.Mode           = GPIO_MODE_AF_PP;
        GPIO_Handle.Pull           = GPIO_PULLUP;
        GPIO_Handle.Alternate      = GPIO_FUNCTION_1;
        HAL_GPIO_Init(GPIOD, &GPIO_Handle);
        
        /* Clear Pending Interrupt */
        NVIC_ClearPendingIRQ(I2C2_IRQn);
        
        /* Enable External Interrupt */
        NVIC_EnableIRQ(I2C2_IRQn);
    }
}
/************************************************************************
 * function   : I2C_Init
 * Description: I2C Initiation. 
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022
 ************************************************************************/ 
void I2C_Init(void)
{
    
    I2C_Handle.Instance         = I2C2;
    I2C_Handle.Init.I2C_Mode    = I2C_MODE_MASTER;
    I2C_Handle.Init.Tx_Auto_En  = TX_AUTO_EN_ENABLE;
    I2C_Handle.Init.Clock_Speed = CLOCK_SPEED_STANDARD;  
    I2C_Handle.Init.No_Stretch_Mode = NO_STRETCH_MODE_NOSTRETCH;   
    
    HAL_I2C_Init(&I2C_Handle);
}
/************************************************************************
* function   : SHT30_Read_Result
* Description: get SHT30 result 
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022
 ************************************************************************/ 
void SHT30_Read_Result(uint8_t *sht30_data,float *getTempHum)
{
	uint16_t tem,hum;
	float Temperature=0;
	float Humidity=0;
    tem = ((sht30_data[0]<<8) | sht30_data[1]);//¶ƴ
    hum = ((sht30_data[3]<<8) | sht30_data[4]);//ʪƴ
    
    /*תʵ¶*/
    Temperature= (175.0*(float)tem/65535.0-45.0) ;// T = -45 + 175 * tem / (2^16-1)
    Humidity= (100.0*(float)hum/65535.0);// RH = hum*100 / (2^16-1)
    
//    if((Temperature>=-20)&&(Temperature<=125)&&(Humidity>=0)&&(Humidity<=100))//˴
//    {
//        printfS("%6.2f*C %6.2f%%",Temperature,Humidity);//111.01*C 100.01%2λС
//    }
    getTempHum[0]=Temperature;
    getTempHum[1]=Humidity;
}
/************************************************************************
 * function   : SHT30_Init
 * Description: SHT30 Initiation. 
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022
 ************************************************************************/ 
void SHT30_Init(void)
{
    I2C_Init();
    SHT30_Reset(I2C_Handle);
}
/*********************************************************************************
* Function    : LCD_Config
* Description : Config LCD
* Input       : 
* Outpu       : 
* Author      : CWT                         Data : 2021
**********************************************************************************/
void LCD_Config(void)
{   
    
#if defined LCD_GDC04212
    LCD_DisplayNum=LCD_DisplayNum_GDC04212;
    LCD_Init=LCD_Init_GDC04212; 
    lcdhandle=&lcdhandle_GDC04212;

#elif defined LCD_GDC03828
    LCD_DisplayNum=LCD_DisplayNum_GDC003828;
    LCD_Init=LCD_Init_GDC03828;
    lcdhandle=&lcdhandle_GDC03828;
#elif defined LCD_YR1618A
    LCD_DisplayNum=LCD_DisplayNum_YR1618A;
    LCD_Init=LCD_Init_YR1618A; 
    lcdhandle=&lcdhandle_YR1618A;
    LCD_YR1618A_BACK_LED();
#elif defined LCD_H50261ARP
    LCD_DisplayNum=LCD_DisplayNum_H50261ARP;
    LCD_Init=LCD_Init_H50261ARP; 
    lcdhandle=&lcdhandle_H50261ARP;
    LCD_H50261ARP_BACK_LED();

#endif  
    LCD_Init();
    
}

/*********************************************************************************
* Function    : LCD_DisplayTest
* Description : LCD DisplayTest
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022
**********************************************************************************/
void LCD_DisplayTest()
{
    while(1)
    {
        #if defined LCD_YR1618A
            LCD_YR1618A_SelfDisplay();
        #elif defined LCD_H50261ARP
            LCD_H50261ARP_SelfDisplay();
        #else
        for(uint16_t i=0;i<10000;i++)   
        {
            LCD_DisplayNum(i);
            System_Delay_MS(100);
        }  
        #endif
    }
}
void EXTI_IRQHandler(void)
{
    HAL_EXTI_IRQHandler(&EXTI_Line13_Handle);
}

/*********************************************************************************
* Function    : LCD_Sleep_DMA_Test
* Description : LCD Display in sleep,use DMA to Reresh data to LCDRAM
* Input       : 
* Outpu       : 
* Author      : CWT                         Data : 2021
**********************************************************************************/
void LCD_Sleep_DMA_Test()/*SleepģʽDMAѭʾ*/
{   
    memset(&DMA_CH1_Handle,0,sizeof(DMA_CH1_Handle));//ʼHandle
    //DMA
    DMA_CH1_Handle.Instance              = DMA_Channel0;
    DMA_CH1_Handle.Init.Data_Flow        = DMA_DATA_FLOW_M2P;
    DMA_CH1_Handle.Init.Request_ID       = REQ22_TIM3_CH2_LCDFRAME;
    DMA_CH1_Handle.Init.Source_Inc       = DMA_SOURCE_ADDR_INCREASE_ENABLE;
    DMA_CH1_Handle.Init.Desination_Inc   = DMA_DST_ADDR_INCREASE_ENABLE;
    DMA_CH1_Handle.Init.Source_Width     = DMA_SRC_WIDTH_WORD;
    DMA_CH1_Handle.Init.Desination_Width = DMA_DST_WIDTH_WORD;
    HAL_DMA_Init(&DMA_CH1_Handle);
    
    DMA_CH1_Handle.Instance->CTRL &= ~DMA_CHANNEL_CTRL_ITC;//رжϣSleepģʽ£1жϻSleep
    
    //DMA1
    DMA_CH1_Handle_link1.SrcAddr = (uint32_t)(wdata1);
    DMA_CH1_Handle_link1.DstAddr = (uint32_t)(&lcdhandle->Instance->LCD_RAM[0]);
    DMA_CH1_Handle_link1.Next = &DMA_CH1_Handle_link2;
    DMA_CH1_Handle_link1.Control = DMA_CH1_Handle.Instance->CTRL | 16;
    
    //DMA2
    DMA_CH1_Handle_link2.SrcAddr = (uint32_t)(wdata2);
    DMA_CH1_Handle_link2.DstAddr = (uint32_t)(&lcdhandle->Instance->LCD_RAM[0]);
    DMA_CH1_Handle_link2.Next = &DMA_CH1_Handle_link3;
    DMA_CH1_Handle_link2.Control = DMA_CH1_Handle.Instance->CTRL | 16;	
    
    //DMA3
    DMA_CH1_Handle_link3.SrcAddr = (uint32_t)(wdata3);
    DMA_CH1_Handle_link3.DstAddr = (uint32_t)(&lcdhandle->Instance->LCD_RAM[0]);
    DMA_CH1_Handle_link3.Next = &DMA_CH1_Handle_link4;
    DMA_CH1_Handle_link3.Control = DMA_CH1_Handle.Instance->CTRL | 16;	
		
    //DMA4
    DMA_CH1_Handle_link4.SrcAddr = (uint32_t)(wdata4);
    DMA_CH1_Handle_link4.DstAddr = (uint32_t)(&lcdhandle->Instance->LCD_RAM[0]);
    DMA_CH1_Handle_link4.Next = &DMA_CH1_Handle_link5;
    DMA_CH1_Handle_link4.Control = DMA_CH1_Handle.Instance->CTRL | 16;	
    //DMA5
    DMA_CH1_Handle_link5.SrcAddr = (uint32_t)(wdata5);
    DMA_CH1_Handle_link5.DstAddr = (uint32_t)(&lcdhandle->Instance->LCD_RAM[0]);
    DMA_CH1_Handle_link5.Next = &DMA_CH1_Handle_link6;
    DMA_CH1_Handle_link5.Control = DMA_CH1_Handle.Instance->CTRL | 16;	
    
    //DMA6
    DMA_CH1_Handle_link6.SrcAddr = (uint32_t)(wdata6);
    DMA_CH1_Handle_link6.DstAddr = (uint32_t)(&lcdhandle->Instance->LCD_RAM[0]);
    DMA_CH1_Handle_link6.Next = &DMA_CH1_Handle_link7;
    DMA_CH1_Handle_link6.Control = DMA_CH1_Handle.Instance->CTRL | 16;	
    
    //DMA7
    DMA_CH1_Handle_link7.SrcAddr = (uint32_t)(wdata7);
    DMA_CH1_Handle_link7.DstAddr = (uint32_t)(&lcdhandle->Instance->LCD_RAM[0]);
    DMA_CH1_Handle_link7.Next =  &DMA_CH1_Handle_link8;
    DMA_CH1_Handle_link7.Control = DMA_CH1_Handle.Instance->CTRL | 16;	
	
    //DMA8
    DMA_CH1_Handle_link8.SrcAddr = (uint32_t)(wdata8);
    DMA_CH1_Handle_link8.DstAddr = (uint32_t)(&lcdhandle->Instance->LCD_RAM[0]);
    DMA_CH1_Handle_link8.Next = &DMA_CH1_Handle_link9;
    DMA_CH1_Handle_link8.Control = DMA_CH1_Handle.Instance->CTRL | 16;	
    //DMA9
    DMA_CH1_Handle_link9.SrcAddr = (uint32_t)(wdata9);
    DMA_CH1_Handle_link9.DstAddr = (uint32_t)(&lcdhandle->Instance->LCD_RAM[0]);
    DMA_CH1_Handle_link9.Next = NULL;
    //һδ俪жϣڻLCDҲɸҪָ1ѭʾ
    DMA_CH1_Handle_link9.Control = DMA_CH1_Handle.Instance->CTRL | 16|(DMA_CHANNEL_CTRL_ITC);
    
    /*ɣDMAַΪ1ʼDMA*/
    DMA_CH1_Handle.Instance->LLI =(uint32_t)&DMA_CH1_Handle_link1;  
    __HAL_LINK_DMA((*lcdhandle), DMA_Handle, DMA_CH1_Handle);
    HAL_LCD_Start_DMA(lcdhandle, wdata1, 16);
    
    /*SleepǰҪرSystickLCDжϣһSleepͱ*/
    SysTick->CTRL = 0;
    lcdhandle->Instance->CR1 &= ~LCD_CR1_IE;
    System_Enter_Sleep_Mode(SLEEPENTRY_WFI);//sleep
    
    /*ɣ˳Sleepʾ1234*/
    LCD_DisplayNum(1234);
}

/*********************************************************************************
* Function    : Exit_Config
* Description : Exit_Config
* Input       : 
* Outpu       : 
* Author      : ZK                         Data : 2022
**********************************************************************************/
void Exit_Config(void)
{    
    /* Initialization GPIO */

    /* RTC access enable */
    System_Enable_Disable_RTC_Domain_Access(FUNC_ENABLE);
    
    __HAL_RTC_PC13_SEL(0);  // GPIO function    
    __HAL_RTC_PC13_PULL_UP_ENABLE();
    __HAL_RTC_PC13_DIGIT();
  
    System_Module_Enable(EN_EXTI);
    /* Config EXTI */
    EXTI_Line13_Handle.u32_Line    = EXTI_LINE_13;
    EXTI_Line13_Handle.u32_Mode    = EXTI_MODE_INTERRUPT;
    EXTI_Line13_Handle.u32_Trigger = EXTI_TRIGGER_FALLING;
    EXTI_Line13_Handle.u32_GPIOSel = EXTI_GPIOC;
    HAL_EXTI_SetConfigLine(&EXTI_Line13_Handle);
}


/*********************************************************************************
* Function    : LCD_StopTest
* Description : LCD Dispaly in Stop
* Input       : 
* Outpu       : 
* Author      : CWT                         Data : 2021
**********************************************************************************/
void LCD_StopTest()/*Stopģʽʾ*/
{   
    LCD_DisplayNum(6666);
    
    Exit_Config();
    HAL_EXTI_ClearAllPending();
    System_Delay_MS(2000);
    System_Enter_Stop_Mode(STOPENTRY_WFI);//STOPѣ鿴Ƿʾ
    
    LCD_DisplayNum(8888);/*ѣ˳Stopʾ8888*/
}


/*********************************************************************************
* Function    : LCD_Test
* Description : LCD Test
* Input       : 
* Outpu       : 
* Author      : CWT                         Data : 2021
**********************************************************************************/
void LCD_Test(enum_TEST_MODE_t fe_Mode)
{    
    switch (fe_Mode)
    {
        /* ʾģʽ */
        case TEST_Dispaly_Normal: 
        {
            LCD_DisplayTest();
        }
        
        /* Stopģʽʾ */
        case TEST_Dispaly_InStop: 
        {
            LCD_StopTest();
            while(1)
            {

            }
        }
    
        /* Sleepģʽ+DMA+ʾ*/
        case TEST_Dispaly_Sleep_DMA: 
        {
            LCD_Sleep_DMA_Test();
            while(1)
            {

            }
        }
        default: break; 
    }
}

/*********************************************************************************
* Function    : Get_Touch_Key_Value
* Description : get key value
* Input       : 
* Output      : key value
* Author      : LWQ                         Data : 2022
**********************************************************************************/
uint8_t Get_Touch_Key_Value(void) 
{
    static uint8_t key_flags = NO_KEY_DOWN;            /* Ƿаµı־ */ 
    static uint32_t key_value = 0; 
    uint8_t i=0, key_num = 0;
    uint32_t uwTouchBits = 0;
    uint32_t uwTouchBits_ref = 0;
    uint32_t uwkey_value = 0; 
    uint8_t  ucKey = 0;

    uwTouchBits = TouchKey_GetPressRelaeseFlag();
    uwTouchBits_ref = uwTouchBits;
    uwkey_value = key_value;
	 
    for(i = 0; i < MAX_KEY_NUM; i++)
    {		
        uwTouchBits &= (~key_value);
        if((uwTouchBits >> i) & 0x0001)
        {
            key_num++;
        }
    }

    if(key_flags == NO_KEY_DOWN)
    {
        if(key_num == 1)
        {
            key_flags = KEY_DOWN;
        }
    }
    else if((key_value & uwTouchBits) == 0)
    {
        if(key_value != uwTouchBits_ref)
        {
            key_flags = NO_KEY_DOWN;
            key_value = 0;
        }

        if(key_num == 1)
        {
            key_flags = OTHER_KEY_DOWN;
        }
    }

    if(key_flags != NO_KEY_DOWN)
    {
        if(key_num == 1 && (key_value & uwTouchBits) == 0)
        {
            for(i = 0; i < MAX_KEY_NUM; i++)
            {
                if((key_num == 1) && ((uwTouchBits >> i) & 0x0001))//жϰֵ
                {							              	       							              
                    if((uwkey_value & uwTouchBits_ref) == 0)
                    {
                        key_value = uwTouchBits;
                        ucKey = i;
                        printfS("TK_%d\r\n", i);
                    }
                    else
                    {
                        key_value = uwkey_value;
                    }

                }
            }
        }
    }
    if(ucKey != 0)//ȷǰ£̧֣
    {	
        Beep_On(5);				
    }         

    return ucKey;
}

void SysTick_Callback(void)
{
    if(gu8_time_count_free==0)
    {
        if(gu32_time_1s_cont==400)
        {
            gu8_time_count_free=2;
            gu32_time_1s_cont=0;
        }
        else if(gu32_time_1s_cont==200)
        {
            gu8_time_count_free=1;
            gu32_time_1s_cont++;
        }
        else 
        {
            gu32_time_1s_cont++;
        }
    }
}

void App_Test(void)
{   

    float ff_getTempHum[2];//ȡʪ
    uint16_t fu16_num_up, fu16_num_down;
    uint32_t fu32_Displayup[4]={0},fu32_Displaydown[4]={0},fu32_num_123567p[7]={0},fu32_num_col[2]={0},fu32_num_s=0;
    uint8_t  fu8_Tkey_state = 0xff, fu8_Work_Mode=0;
    uint16_t fu16_set_num_up=0,fu16_set_num_down=0;
    uint8_t  fu8_Hidden_point=0;//ص
    uint8_t  ret = 0;
  
    LCD_Config();  

    SHT30_Init();

    BUZZER_Init();
  
    ret = TouchKey_Init();
    if(ret)
    {
        printfS("TouchKey_Init is Fail!\r\n");
    }
    else
    {
        printfS("TouchKey_Init is Success!\r\n");      
    }
    
    #if defined LCD_YR1618A
        LCD_YR1618A_SelfDisplay();
    #elif defined LCD_H50261ARP
        LCD_H50261ARP_SelfDisplay();
    #endif    
    
    SysTick_Handler_Callback = SysTick_Callback;
    while(1)
    {
        fu8_Tkey_state = TouchKey_TimerSacn_GetKeyVal();//Get_Touch_Key_Value();
        if(fu8_Tkey_state != 0xFF)
        {
            Beep_On(5);
        #ifndef TKEY_WAVEFORM_OUTPUT 
            printfS("TK_%d\r\n", fu8_Tkey_state);
        #endif
        }
        TKEY_Calibrate_Process();
        if(fu8_Work_Mode == 0)//ģʽ
        {
			if(fu8_Tkey_state == 15)//ȷϡлģʽ
            {
                fu8_Work_Mode = 1;
            }
			
			if(gu8_time_count_free == 1)
            {
                gu8_time_count_free=0;
            }
    #if defined LCD_YR1618A
            else if(gu8_time_count_free == 2)
			{
				gu8_time_count_free=0;
				SHT30_Read_Dat(I2C_Handle,gu8_RxBuffer);
                SHT30_Read_Result(gu8_RxBuffer,ff_getTempHum);
				fu16_num_up=(uint16_t)(ff_getTempHum[0]*100);
				fu16_num_down=(uint16_t)(ff_getTempHum[1]*100);
				fu32_num_123567p[1] |=1;
				fu32_num_123567p[4] |=1;
				fu32_num_s |=YR1618A_S_DATA[1];
				fu32_num_s |=YR1618A_S_DATA[3];
				fu32_num_s &=~YR1618A_S_DATA[0];
				fu32_num_s |=YR1618A_S_DATA[12];//S13_BATW,S14_BAT1,S15_BAT2,S16_BAT3
				fu32_num_s |=YR1618A_S_DATA[13];
				fu32_num_s |=YR1618A_S_DATA[14];
				fu32_num_s |=YR1618A_S_DATA[15];
				
				if(fu16_num_up>9999) fu16_num_up=9999;//4λʾ9999
				fu32_Displayup[0]=fu16_num_up/1000%10;//ǧλ,LCD1λ()--5
				fu32_Displayup[1]=fu16_num_up/100%10;//λ,LCD2λ()---6
				fu32_Displayup[2]=fu16_num_up/10%10;//ʮλ,LCD3λ()----7
				fu32_Displayup[3]=fu16_num_up/1%10;//λ,LCD4λ()-----8
				
				if(fu16_num_down>9999) fu16_num_down=9999;//4λʾ9999
				fu32_Displaydown[0]=fu16_num_down/1000%10;//ǧλ,LCD1λ()--5
				fu32_Displaydown[1]=fu16_num_down/100%10;//λ,LCD2λ()---6
				fu32_Displaydown[2]=fu16_num_down/10%10;//ʮλ,LCD3λ()----7
				fu32_Displaydown[3]=fu16_num_down/1%10;//λ,LCD4λ()-----8		
				LCD_YR1618A_VIEW(fu32_Displayup,fu32_Displaydown,fu32_num_123567p,fu32_num_col,fu32_num_s);
			}
        }
        else //ģʽ
        {
            if(fu8_Tkey_state == 10)//ءлģʽ
            {                   
                fu8_Work_Mode = 0;
            }
            else if(fu8_Tkey_state == 7)//
            {
                if(fu8_Hidden_point<7)fu8_Hidden_point++;
            }
            else if(fu8_Tkey_state == 9)//ҡ
            {
                if(fu8_Hidden_point>0)fu8_Hidden_point--;
            }
            else if(fu8_Tkey_state == 11)//ϡ
            {
                switch(fu8_Hidden_point)
                {
                    case 0: 
                        if(fu16_set_num_up<9000)
                        fu16_set_num_up+=1000;
                        break;
                    case 1:
                        fu16_set_num_up+=100;
                        break;
                    case 2: 
                        fu16_set_num_up+=10;
                        break;
                    case 3: 
                        fu16_set_num_up+=1;
                        break;		
                    case 4:
                        if(fu16_set_num_down<9000)
                        fu16_set_num_down+=1000;
                        break;
                    case 5:
                        fu16_set_num_down+=100;
                        break;
                    case 6:
                        fu16_set_num_down+=10;
                        break;
                    case 7:
                        fu16_set_num_down+=1;
                        break;							
                };
            }
            else if(fu8_Tkey_state == 8)//¡
            {
                switch(fu8_Hidden_point)
                {
                    case 0:
                        if(fu16_set_num_up>=1000)
                        fu16_set_num_up-=1000;
                        break;
                    case 1:
                        if(fu16_set_num_up>=100)
                        fu16_set_num_up-=100;
                        break;
                    case 2:
                        if(fu16_set_num_up>=10)
                        fu16_set_num_up-=10;
                        break;
                    case 3: 
                        if(fu16_set_num_up>0)
                        fu16_set_num_up-=1;
                        break;		
                    case 4:
                        if(fu16_set_num_down>=1000)
                        fu16_set_num_down-=1000;
                        break;
                    case 5: 
                        if(fu16_set_num_down>=100)
                        fu16_set_num_down-=100;
                        break;
                    case 6:
                        if(fu16_set_num_down>=10)
                        fu16_set_num_down-=10;
                        break;
                    case 7:
                        if(fu16_set_num_down>0)
                        fu16_set_num_down-=1;
                        break;							
                };
            }
        }	
        if( (gu8_time_count_free==1) && (fu8_Work_Mode == 1) ) 
		{
            gu8_time_count_free=0;
            if(fu16_set_num_up>9999) fu16_set_num_up=9999;//4λʾ9999
            fu32_Displayup[0]=fu16_set_num_up/1000%10;//ǧλ,LCD1λ()--5
            fu32_Displayup[1]=fu16_set_num_up/100%10;//λ,LCD2λ()---6
            fu32_Displayup[2]=fu16_set_num_up/10%10;//ʮλ,LCD3λ()----7
            fu32_Displayup[3]=fu16_set_num_up/1%10;//λ,LCD4λ()-----8
            
            if(fu16_set_num_down>9999) fu16_set_num_down=9999;//4λʾ9999
            fu32_Displaydown[0]=fu16_set_num_down/1000%10;//ǧλ,LCD1λ()--5
            fu32_Displaydown[1]=fu16_set_num_down/100%10;//λ,LCD2λ()---6
            fu32_Displaydown[2]=fu16_set_num_down/10%10;//ʮλ,LCD3λ()----7
            fu32_Displaydown[3]=fu16_set_num_down/1%10;//λ,LCD4λ()-----8	
            switch(fu8_Hidden_point)
            {
                case 0://up 
                    fu32_Displayup[0]=10;
                    break;
                case 1://up 
                    fu32_Displayup[1]=10;
                    break;
                case 2://up 
                    fu32_Displayup[2]=10;
                    break;
                case 3://up 
                    fu32_Displayup[3]=10;
                    break;		
                case 4://up 
                    fu32_Displaydown[0]=10;
                    break;
                case 5://up 
                    fu32_Displaydown[1]=10;
                    break;
                case 6://up 
                    fu32_Displaydown[2]=10;
                    break;
                case 7://up 
                    fu32_Displaydown[3]=10;
                    break;							
            }; 
            LCD_YR1618A_VIEW(fu32_Displayup,fu32_Displaydown,fu32_num_123567p,fu32_num_col,fu32_num_s);
        }
        else if ( (gu8_time_count_free==2) && (fu8_Work_Mode == 1) ) 
        {
            gu8_time_count_free=0;
            fu32_num_123567p[1] |=1;
            fu32_num_123567p[4] |=1;
            fu32_num_s |=YR1618A_S_DATA[1];
            fu32_num_s |=YR1618A_S_DATA[3];
            fu32_num_s |=YR1618A_S_DATA[0];
            
            fu32_num_s &=~YR1618A_S_DATA[12];//S13_BATW,S14_BAT1,S15_BAT2,S16_BAT3
            fu32_num_s &=~YR1618A_S_DATA[13];
            fu32_num_s &=~YR1618A_S_DATA[14];
            fu32_num_s &=~YR1618A_S_DATA[15];
            if(fu16_set_num_up>9999) fu16_set_num_up=9999;//4λʾ9999
            fu32_Displayup[0]=fu16_set_num_up/1000%10;//ǧλ,LCD1λ()--5
            fu32_Displayup[1]=fu16_set_num_up/100%10;//λ,LCD2λ()---6
            fu32_Displayup[2]=fu16_set_num_up/10%10;//ʮλ,LCD3λ()----7
            fu32_Displayup[3]=fu16_set_num_up/1%10;//λ,LCD4λ()-----8
            
            if(fu16_set_num_down>9999) fu16_set_num_down=9999;//4λʾ9999
            fu32_Displaydown[0]=fu16_set_num_down/1000%10;//ǧλ,LCD1λ()--5
            fu32_Displaydown[1]=fu16_set_num_down/100%10;//λ,LCD2λ()---6
            fu32_Displaydown[2]=fu16_set_num_down/10%10;//ʮλ,LCD3λ()----7
            fu32_Displaydown[3]=fu16_set_num_down/1%10;//λ,LCD4λ()-----8			
            LCD_YR1618A_VIEW(fu32_Displayup,fu32_Displaydown,fu32_num_123567p,fu32_num_col,fu32_num_s);
        }
    #elif defined LCD_H50261ARP
            else if(gu8_time_count_free == 2)
            {
                gu8_time_count_free=0;
                SHT30_Read_Dat(I2C_Handle,gu8_RxBuffer);
                SHT30_Read_Result(gu8_RxBuffer,ff_getTempHum);
                fu16_num_up=(uint16_t)(ff_getTempHum[0]*100);
                fu16_num_down=(uint16_t)(ff_getTempHum[1]*100);
                fu32_num_123567p[1] |=1;
                fu32_num_123567p[4] |=1;
                fu32_num_s |=H50261ARP_S_DATA[0];
                fu32_num_s |=H50261ARP_S_DATA[1];
                //fu32_num_s &=~H50261ARP_S_DATA[0];
                fu32_num_s |=H50261ARP_S_DATA[2];
                fu32_num_s |=H50261ARP_S_DATA[3];//S13_BATW,S14_BAT1,S15_BAT2,S16_BAT3
                fu32_num_s |=H50261ARP_S_DATA[4];
                fu32_num_s |=H50261ARP_S_DATA[5];
                fu32_num_s |=H50261ARP_S_DATA[6];

                if(fu16_num_up>9999) fu16_num_up=9999;//4λʾ9999
                fu32_Displayup[0]=fu16_num_up/1000%10;//ǧλ,LCD1λ()--5
                fu32_Displayup[1]=fu16_num_up/100%10;//λ,LCD2λ()---6
                fu32_Displayup[2]=fu16_num_up/10%10;//ʮλ,LCD3λ()----7

                if(fu16_num_down>9999) fu16_num_down=9999;//4λʾ9999
                fu32_Displaydown[0]=fu16_num_down/1000%10;//ǧλ,LCD1λ()--5
                fu32_Displaydown[1]=fu16_num_down/100%10;//λ,LCD2λ()---6		
                LCD_H50261ARP_VIEW(fu32_Displayup,fu32_Displaydown,fu32_num_123567p,fu32_num_col,fu32_num_s);
            }
        }
        else //ģʽ
        {
            if(fu8_Tkey_state == 10)//ءлģʽ
            {                   
                fu8_Work_Mode = 0;
            }
            else if(fu8_Tkey_state == 7)//
            {
                if(fu8_Hidden_point<5)fu8_Hidden_point++;
            }
            else if(fu8_Tkey_state == 9)//ҡ
            {
                if(fu8_Hidden_point>0)fu8_Hidden_point--;
            }
            else if(fu8_Tkey_state == 11)//ϡ
            {
                switch(fu8_Hidden_point)
                {
                    case 0: 
                        if(fu16_set_num_up<9000)
                        fu16_set_num_up+=1000;
                        break;
                    case 1:
                        fu16_set_num_up+=100;
                        break;
                    case 2: 
                        fu16_set_num_up+=10;
                        break;		
                    case 3:
                        if(fu16_set_num_down<9000)
                        fu16_set_num_down+=1000;
                        break;
                    case 4:
                        fu16_set_num_down+=100;
                        break;						
                };
            }
            else if(fu8_Tkey_state == 8)//¡
            {
                switch(fu8_Hidden_point)
                {
                    case 0:
                        if(fu16_set_num_up>=1000)
                        fu16_set_num_up-=1000;
                        break;
                    case 1:
                        if(fu16_set_num_up>=100)
                        fu16_set_num_up-=100;
                        break;
                    case 2:
                        if(fu16_set_num_up>=10)
                        fu16_set_num_up-=10;
                        break;		
                    case 3:
                        if(fu16_set_num_down>=1000)
                        fu16_set_num_down-=1000;
                        break;
                    case 4: 
                        if(fu16_set_num_down>=100)
                        fu16_set_num_down-=100;
                        break;						
                };
            }
        }	
        if( (gu8_time_count_free==1) && (fu8_Work_Mode == 1) ) 
		{
            gu8_time_count_free=0;
            if(fu16_set_num_up>9999) fu16_set_num_up=9999;//4λʾ9999
            fu32_Displayup[0]=fu16_set_num_up/1000%10;//ǧλ,LCD1λ()--5
            fu32_Displayup[1]=fu16_set_num_up/100%10;//λ,LCD2λ()---6
            fu32_Displayup[2]=fu16_set_num_up/10%10;//ʮλ,LCD3λ()----7
            
            if(fu16_set_num_down>9999) fu16_set_num_down=9999;//4λʾ9999
            fu32_Displaydown[0]=fu16_set_num_down/1000%10;//ǧλ,LCD1λ()--5
            fu32_Displaydown[1]=fu16_set_num_down/100%10;//λ,LCD2λ()---6	
            switch(fu8_Hidden_point)
            {
                case 0://up 
                    fu32_Displayup[0]=10;
                    break;
                case 1://up 
                    fu32_Displayup[1]=10;
                    break;
                case 2://up 
                    fu32_Displayup[2]=10;
                    break;		
                case 3://up 
                    fu32_Displaydown[0]=10;
                    break;
                case 4://up 
                    fu32_Displaydown[1]=10;
                    break;							
            }; 
            LCD_H50261ARP_VIEW(fu32_Displayup,fu32_Displaydown,fu32_num_123567p,fu32_num_col,fu32_num_s);
        }
        else if ( (gu8_time_count_free==2) && (fu8_Work_Mode == 1) ) 
        {
            gu8_time_count_free=0;
            fu32_num_123567p[1] |=1;
            fu32_num_123567p[4] |=1;
            fu32_num_s |=H50261ARP_S_DATA[1];
            fu32_num_s |=H50261ARP_S_DATA[3];
            fu32_num_s |=H50261ARP_S_DATA[0];
            
            fu32_num_s &=~H50261ARP_S_DATA[12];//S13_BATW,S14_BAT1,S15_BAT2,S16_BAT3
            fu32_num_s &=~H50261ARP_S_DATA[13];
            fu32_num_s &=~H50261ARP_S_DATA[14];
            fu32_num_s &=~H50261ARP_S_DATA[15];
            if(fu16_set_num_up>9999) fu16_set_num_up=9999;//4λʾ9999
            fu32_Displayup[0]=fu16_set_num_up/1000%10;//ǧλ,LCD1λ()--5
            fu32_Displayup[1]=fu16_set_num_up/100%10;//λ,LCD2λ()---6
            fu32_Displayup[2]=fu16_set_num_up/10%10;//ʮλ,LCD3λ()----7
            
            if(fu16_set_num_down>9999) fu16_set_num_down=9999;//4λʾ9999
            fu32_Displaydown[0]=fu16_set_num_down/1000%10;//ǧλ,LCD1λ()--5
            fu32_Displaydown[1]=fu16_set_num_down/100%10;//λ,LCD2λ()---6			
            LCD_H50261ARP_VIEW(fu32_Displayup,fu32_Displaydown,fu32_num_123567p,fu32_num_col,fu32_num_s);
        }
    #endif
    }
    

}
