/*
  ******************************************************************************
  * Copyright (c)  2008 - 2022, Shanghai AisinoChip Co.,Ltd .
  * @file    APP.c 
  * @version V1.0.0
  * @date    2022
  * @author  Aisinochip Firmware Team  
  * @brief   EXTI demo source code.
  ******************************************************************************        
*/
#include "APP.h"

EXTI_HandleTypeDef EXTI_Line_Handle;


GPIO_InitTypeDef GPIO_PB1_Handle;

RTC_ConfigTypeDef RTC_Handle;

RTC_TimeTypeDef  gstr_Time_Set;
RTC_DateTypeDef  gstr_Date_Set;
/*********************************************************************************
* Function    : EXTI_IRQHandler
* Description : EXTI_IRQHandler
**********************************************************************************/
void EXTI_IRQHandler(void)
{    
    HAL_EXTI_IRQHandler(&EXTI_Line_Handle);
}

/*********************************************************************************
* Function    : RTC_IRQHandler
* Description : RTC_IRQHandler
**********************************************************************************/
void RTC_IRQHandler(void)
{
	if (RTC->SR & RTC_SR_MIN) 
    {
        RTC->SR |= RTC_SR_MIN;
    }
}

/*********************************************************************************
* Function    : APP_EXTI_Test
* Description : MCU STOP wakeup Test
* Input       : fe_Mode: Test Case
* Output      : None
**********************************************************************************/
void APP_EXTI_Test(enum_TEST_MODE_t fe_Mode)
{
    System_Delay_MS(3000);  

    printfS("This is EXTI Test \r\n");
    
    System_Module_Enable(EN_EXTI);
	
	switch(fe_Mode)
	{
		case TEST_EXIT_GPIO:
			/* Initialization GPIO */
			GPIO_PB1_Handle.Pin       = GPIO_PIN_1;
			GPIO_PB1_Handle.Mode      = GPIO_MODE_INPUT;
			GPIO_PB1_Handle.Pull      = GPIO_PULLUP;
			GPIO_PB1_Handle.Alternate = GPIO_FUNCTION_0;

			HAL_GPIO_Init(GPIOB, &GPIO_PB1_Handle);
			
			/* Config EXTI */
			EXTI_Line_Handle.u32_Line    = EXTI_LINE_1;
			EXTI_Line_Handle.u32_Mode    = EXTI_MODE_INTERRUPT;
			EXTI_Line_Handle.u32_Trigger = EXTI_TRIGGER_FALLING;    
			EXTI_Line_Handle.u32_GPIOSel = EXTI_GPIOB;

			HAL_EXTI_SetConfigLine(&EXTI_Line_Handle);

			while (1) 
			{
				printfS("MCU Enter Lowpower, Let PB1 Fall Down Wakeup MCU!\n");    
				System_Enter_Stop_Mode(MODE_WFI);

				printfS("MCU is Runing \r\n");
				System_Delay_MS(200);
				printfS("MCU is Runing \r\n");
				System_Delay_MS(200);
			}
		case TEST_EXTI_RTC:
			/********************************************/
			/**************** RTC Config ****************/
			/********************************************/
			RTC_Handle.u32_ClockSource       = RTC_CLOCK_XTL;
			RTC_Handle.u32_Compensation      = COMPENSATION_INCREASE;    // ʼʱӲ粻貹òֵΪ0
			RTC_Handle.u32_CompensationValue = 0x05;                     // ʼʱӲ粻貹òֵΪ0

			HAL_RTC_Config(&RTC_Handle);  
			
			/* Set RTC TimeDate */
			gstr_Time_Set.u8_Hours   = 0x12;
			gstr_Time_Set.u8_Minutes = 0x30;
			gstr_Time_Set.u8_Seconds = 0x00;
			HAL_RTC_SetTime(&gstr_Time_Set);

			gstr_Date_Set.u8_Year    = 0x21;     
			gstr_Date_Set.u8_Month   = RTC_MONTH_MARCH;  
			gstr_Date_Set.u8_Date    = 0x20; 
			gstr_Date_Set.u8_WeekDay = RTC_WEEKDAY_FRIDAY;
			HAL_RTC_SetDate(&gstr_Date_Set);
			
			NVIC_ClearPendingIRQ(RTC_IRQn);
			NVIC_EnableIRQ(RTC_IRQn);
			__HAL_RTC_ENABLE_MIN_IT;
			
			/* Config EXTI */
			EXTI_Line_Handle.u32_Line    = EXTI_LINE_17;
			EXTI_Line_Handle.u32_Mode    = EXTI_MODE_INTERRUPT;
			EXTI_Line_Handle.u32_Trigger = EXTI_TRIGGER_RISING;    
			HAL_EXTI_SetConfigLine(&EXTI_Line_Handle);
			while (1) 
			{
				printfS("MCU Enter Lowpower, Wait RTC 1 Minute  Wakeup MCU!\n");    
				System_Enter_Stop_Mode(MODE_WFI);
				
				printfS("MCU is Runing \r\n");
				System_Delay_MS(200);
				printfS("MCU is Runing \r\n");
				System_Delay_MS(200);
			}
		default:
			break;		
	}   
}

