/* File: startup_ARMCM0.S
 * Purpose: startup file for Cortex-M0 devices. Should use with
 *   GCC for ARM Embedded Processors
 * Version: V2.0
 * Date: 16 August 2013
 *
 * Copyright (c) 2011 - 2013 ARM LIMITED

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
   ---------------------------------------------------------------------------*/
    .syntax     unified
    .arch       armv6-m

    .section .stack
    .align      3
    .equ        Stack_Size, 0xc00
    .globl      __StackTop
    .globl      __StackLimit
__StackLimit:
    .space      Stack_Size
    .size       __StackLimit, . - __StackLimit
__StackTop:
    .size       __StackTop, . - __StackTop

    .section    .heap
    .align      3
    .equ        Heap_Size, 0

    .globl      __HeapBase
    .globl      __HeapLimit
__HeapBase:
    .if         Heap_Size
    .space      Heap_Size
    .endif
    .size       __HeapBase, . - __HeapBase
__HeapLimit:
    .size       __HeapLimit, . - __HeapLimit

    .section    .isr_vector
    .align 2
    .globl      __isr_vector
__isr_vector:
    .long       __StackTop                      /* Top of Stack */
    .long       Reset_Handler                   /* Reset Handler */
    .long       NMI_Handler                     /* NMI Handler */
    .long       HardFault_Handler               /* Hard Fault Handler */
    .long       MemManage_Handler               /* Reserved */
    .long       0                               /* Reserved */
    .long       0                               /* Reserved */
    .long       0                               /* Reserved */
    .long       0                               /* Reserved */
    .long       0                               /* Reserved */
    .long       0                               /* Reserved */
    .long       SVC_Handler                     /* SVCall Handler */
    .long       0                               /* Reserved */
    .long       0                               /* Reserved */
    .long       PendSV_Handler                  /* PendSV Handler */
    .long       SysTick_Handler                 /* SysTick Handler */

    /* External interrupts */
    .long       WDT_IRQHandler                  /* 0:  WDT_IRQHandler   */
    .long       RTC_IRQHandler                  /* 1:  RTC_IRQHandler    */
    .long       EFC_IRQHandler                  /* 2:  EFC_IRQHandler    */
    .long       GPIOAB_IRQHandler               /* 3:  GPIOAB_IRQHandler */
    .long       GPIOCD_IRQHandler               /* 4:  GPIOCD_IRQHandler */
    .long       EXTI_IRQHandler                 /* 5:  EXTI_IRQHandler   */
    .long       SRAM_PARITY_IRQHandler          /* 6:  SRAM_PARITY_IRQHandler */
    .long       CLKRDY_IRQHandler               /* 7:  CLKRDY_IRQHandler */
    .long       LCD_IRQHandler                  /* 8:  LCD_IRQHandler    */
    .long       DMA_IRQHandler                  /* 9:  DMA_IRQHandler    */
    .long       UART3_IRQHandler                /* 10: UART3_IRQHandler  */
    .long       TKEY_IRQHandler                 /* 11: TKEY_IRQHandler   */
    .long       ADC_IRQHandler                  /* 12: ADC_IRQHandler    */
    .long       TIM1_BRK_UP_TRG_COM_IRQHandler  /* 13: TIM1_BRK_UP_TRG_COM_IRQHandler */
    .long       TIM1_CC_IRQHandler              /* 14: TIM1_CC_IRQHandler */
    .long       RSV_IRQHandler                  /* 15: Reserved          */
    .long       TIM3_IRQHandler                 /* 16: TIM3_IRQHandler   */
    .long       TIM6_IRQHandler                 /* 17: TIM6_IRQHandler   */
    .long       RSV_IRQHandler                  /* 18: Reserved          */
    .long       TIM14_IRQHandler                /* 19: TIM14_IRQHandler  */
    .long       TIM15_IRQHandler                /* 20: TIM15_IRQHandler  */
    .long       TIM16_IRQHandler                /* 21: TIM16_IRQHandler  */
    .long       TIM17_IRQHandler                /* 22: TIM17_IRQHandler  */
    .long       I2C1_IRQHandler                 /* 23: I2C1_IRQHandler   */
    .long       I2C2_IRQHandler                 /* 24: I2C2_IRQHandler   */
    .long       SPI1_IRQHandler                 /* 25: SPI1_IRQHandler   */
    .long       SPI2_IRQHandler                 /* 26: SPI2_IRQHandler   */
    .long       UART1_IRQHandler                /* 27: UART1_IRQHandler  */
    .long       UART2_IRQHandler                /* 28: UART2_IRQHandler  */
    .long       LPUART_IRQHandler               /* 29: LPUART_IRQHandler */
    .long       CAN1_IRQHandler                 /* 30: CAN1_IRQHandler   */
    .long       AES_IRQHandler                  /* 31: AES_IRQHandler    */

    .size       __isr_vector, . - __isr_vector

    .text
    .thumb
    .thumb_func
    .align    1
    .globl      Reset_Handler
    .type       Reset_Handler, %function
Reset_Handler:
    ldr    r1, =__etext
    ldr    r2, =__data_start__
    ldr    r3, =__data_end__

    subs    r3, r2
    ble    .L_loop1_done

.L_loop1:
    subs   r3, #4
    ldr    r0, [r1,r3]
    str    r0, [r2,r3]
    bgt    .L_loop1

.L_loop1_done:
    ldr    r1, =__bss_start__
    ldr    r2, =__bss_end__

    movs   r0, 0

    subs   r2, r1
    ble    .L_loop3_done

.L_loop3:
    subs   r2, #4
    str    r0, [r1, r2]
    bgt    .L_loop3
.L_loop3_done:
    bl     _start

    .pool
    .size    Reset_Handler, . - Reset_Handler

    .align    1
    .thumb_func
    .weak    Default_Handler
    .type    Default_Handler, %function
Default_Handler:
    b    .
    .size    Default_Handler, . - Default_Handler

/*    Macro to define default handlers. Default handler
 *    will be weak symbol and just dead loops. They can be
 *    overwritten by other handlers */
    .macro    def_irq_handler    handler_name
    .weak    \handler_name
    .set    \handler_name, Default_Handler
    .endm

    def_irq_handler    NMI_Handler
    def_irq_handler    HardFault_Handler
    def_irq_handler    MemManage_Handler
    def_irq_handler    SVC_Handler
    def_irq_handler    PendSV_Handler
    def_irq_handler    SysTick_Handler
    def_irq_handler    WDT_IRQHandler                  /* 0:  WDT_IRQHandler   */
    def_irq_handler    RTC_IRQHandler                  /* 1:  RTC_IRQHandler    */
    def_irq_handler    EFC_IRQHandler                  /* 2:  EFC_IRQHandler    */
    def_irq_handler    GPIOAB_IRQHandler               /* 3:  GPIOAB_IRQHandler */
    def_irq_handler    GPIOCD_IRQHandler               /* 4:  GPIOCD_IRQHandler */
    def_irq_handler    EXTI_IRQHandler                 /* 5:  EXTI_IRQHandler   */
    def_irq_handler    SRAM_PARITY_IRQHandler          /* 6:  SRAM_PARITY_IRQHandler */
    def_irq_handler    CLKRDY_IRQHandler               /* 7:  CLKRDY_IRQHandler */
    def_irq_handler    LCD_IRQHandler                  /* 8:  LCD_IRQHandler    */
    def_irq_handler    DMA_IRQHandler                  /* 9:  DMA_IRQHandler    */
    def_irq_handler    UART3_IRQHandler                /* 10: UART3_IRQHandler  */
    def_irq_handler    TKEY_IRQHandler                 /* 11: TKEY_IRQHandler   */
    def_irq_handler    ADC_IRQHandler                  /* 12: ADC_IRQHandler    */
    def_irq_handler    TIM1_BRK_UP_TRG_COM_IRQHandler  /* 13: TIM1_BRK_UP_TRG_COM_IRQHandler */
    def_irq_handler    TIM1_CC_IRQHandler              /* 14: TIM1_CC_IRQHandler */
    def_irq_handler    TIM3_IRQHandler                 /* 16: TIM3_IRQHandler   */
    def_irq_handler    TIM6_IRQHandler                 /* 17: TIM6_IRQHandler   */
    def_irq_handler    RSV_IRQHandler                  /* 18: Reserved          */
    def_irq_handler    TIM14_IRQHandler                /* 19: TIM14_IRQHandler  */
    def_irq_handler    TIM15_IRQHandler                /* 20: TIM15_IRQHandler  */
    def_irq_handler    TIM16_IRQHandler                /* 21: TIM16_IRQHandler  */
    def_irq_handler    TIM17_IRQHandler                /* 22: TIM17_IRQHandler  */
    def_irq_handler    I2C1_IRQHandler                 /* 23: I2C1_IRQHandler   */
    def_irq_handler    I2C2_IRQHandler                 /* 24: I2C2_IRQHandler   */
    def_irq_handler    SPI1_IRQHandler                 /* 25: SPI1_IRQHandler   */
    def_irq_handler    SPI2_IRQHandler                 /* 26: SPI2_IRQHandler   */
    def_irq_handler    UART1_IRQHandler                /* 27: UART1_IRQHandler  */
    def_irq_handler    UART2_IRQHandler                /* 28: UART2_IRQHandler  */
    def_irq_handler    LPUART_IRQHandler               /* 29: LPUART_IRQHandler */
    def_irq_handler    CAN1_IRQHandler                 /* 30: CAN1_IRQHandler   */
    def_irq_handler    AES_IRQHandler                  /* 31: AES_IRQHandler    */

    .end
