/*
  ******************************************************************************
  * @file    APP.c
  * @author  Ellsion
  * @version V1.0.0
  * @date    2021
  * @brief  
  ******************************************************************************        
*/
#include "APP.h"

/*********************************************************************************
* Function    : APP_Test
* Description : LVD Test
**********************************************************************************/
void APP_Test(void)
{
    printfS("MCU BOR Test \r\n");
    
    /* BOR ѹѡ 2.90V/2.77V */
    HAL_RTC_BORResetConfig(RPMU_BORVOLTAGE_2V77_2V9);
    
    if (HAL_RTC_Get_StandbyStatus())
    {
        printfS("MCU Entered Standby Mode \r\n");

        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_WKUP1)
        {        
            printfS("MCU Wakeup source --> WKUP1 \r\n");
        }
        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_WKUP2)
        {        
            printfS("MCU Wakeup source --> WKUP2 \r\n");
        }
        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_WKUP3)
        { 
            printfS("MCU Wakeup source --> WKUP3 \r\n");
        }
        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_WKUP4)
        { 
            printfS("MCU Wakeup source --> WKUP4 \r\n");
        }
        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_WKUP5)
        { 
            printfS("MCU Wakeup source --> WKUP5 \r\n");
        }
        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_WKUP6)
        { 
            printfS("MCU Wakeup source --> WKUP6 \r\n");
        }
        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_RTCWUF)
        { 
            printfS("MCU Wakeup source --> RTC \r\n");
        }
        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_RSTWUF)
        {        
            printfS("MCU Wakeup source --> Reset \r\n");
        }
        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_IWDTWUF)
        { 
            printfS("MCU Wakeup source --> IWDT \r\n");
        }
        if (HAL_RTC_Get_StandbyWakeupSource() & RTC_WAKEUP_SOURCE_BORWUF)
        { 
            printfS("MCU Wakeup source --> BOR Reset \r\n");
        }
    }

    System_Delay_MS(3000);
    
    
    printfS("MCU enter standby mode \r\n");

    HAL_RTC_Standby_Wakeup(RTC_WAKEUP_WKUP2, STANDBY_WAKEUP_RISING);    

    while(1)
    {
        printfS("MCU never run here \r\n");
    }
    

}
